# AdvEDM

The source code of our paper "AdvEDM: Fine-grained Adversarial Attack against VLM-based Embodied Decision-Making Systems".

## Setup Environment

This demo code of our attacks against LLaVA is based on [LLaVA](https://github.com/haotian-liu/LLaVA) , the setup environment and configurations can be found in that repositories.

## Download Models

We download llava-llama-2-13b for evaluation our attacks and the surrogate model is [openai/clip-vit-large-patch14]([openai/clip-vit-large-patch14 · Hugging Face](https://huggingface.co/openai/clip-vit-large-patch14)). You can download them by following the instructions in LLaVA's repositories. 

## Data Preparation

Download the dataset MS-COCO 2014 or MS-COCO 2017, and select part of images for generating adversarial examples. The path is as follows:

```
Source Code
├── data
│   ├── disappear
        ├── image1.jpg
    ├── appear
        ├── image1.jpg
    ├── coco_disappear.json
    ├── coco_appear.json
```

In the JSON file, we specify the attack target for each image and annotate the original semantics. The format follows the example we provide.

## AdvEDM-R

After preparing the data and models, you should complete the corresponding paths in coco_rm.py. Then you can generate adversarial examples with AdvEDM-R by running:

```
python coco_rm.py
```

## AdvEDM-A

Similarly, you can generate adversarial examples with AdvEDM-A by running:

```
python coco_add.py
```

## Evaluation 

To evaluate the attack effectiveness, you can execute the following instruction:

```
python llava_llama_v2_inference --model-path xxx --gpu-id xxx  --image_file xxx  --output_file xxx
```

Then you can calculate the metrics ASR, SPR and SS by these instructions. (Note that you should complete your own API keys to use LLMs):

```
python evaluate/calculate_ASR.py   # ASR metric

python evaluate/compare_result.py  # SPR metric

python evaluate/compare_encoder_score.py   # SS metric
```



## Acknowledgement

Our implementation is built upon the open-source codebases of the following research, and we sincerely thank the authors for their contributions.

```
@misc{qi2023visual,
      title={Visual Adversarial Examples Jailbreak Aligned Large Language Models}, 
      author={Xiangyu Qi and Kaixuan Huang and Ashwinee Panda and Peter Henderson and Mengdi Wang and Prateek Mittal},
      year={2023},
      eprint={2306.13213},
      archivePrefix={arXiv},
      primaryClass={cs.CR}
}

@misc{liu2024llavanext,
    title={LLaVA-NeXT: Improved reasoning, OCR, and world knowledge},
    url={https://llava-vl.github.io/blog/2024-01-30-llava-next/},
    author={Liu, Haotian and Li, Chunyuan and Li, Yuheng and Li, Bo and Zhang, Yuanhan and Shen, Sheng and Lee, Yong Jae},
    month={January},
    year={2024}
}

@misc{liu2023improvedllava,
      title={Improved Baselines with Visual Instruction Tuning}, 
      author={Liu, Haotian and Li, Chunyuan and Li, Yuheng and Lee, Yong Jae},
      publisher={arXiv:2310.03744},
      year={2023},
}

```



